# Get the full path to the current script's directory
$scriptDirectory = Split-Path -Path $MyInvocation.MyCommand.Definition -Parent
# Construct the full path to Install.ps1
$scriptPath = Join-Path -Path $scriptDirectory -ChildPath "Install.ps1"

# Function to run a script as administrator
function Run-AsAdmin {
    param (
        [string]$cmd = $(throw "A command is required")
    )

    # Start a new process with elevated privileges
    Start-Process powershell -ArgumentList "-NoProfile -ExecutionPolicy Bypass -File `"$cmd`"" -Verb RunAs
}

# Call the function with the path to your script
Run-AsAdmin -cmd $scriptPath
